/*****************************************************************************/
/* FILE NAME: main.c                            COPYRIGHT (c) Freescale 2010 */
/*                                                       All Rights Reserved */
/*  									     								 */
/* MPC5668 Example Projects Suite					     					 */
/* LIN Examples							            						 */
/*									    									 */
/* Revision History														     */
/*      Rev: 1.0 		Author:	Martin Vaupel				DATE: 16/11/2010 */
/*									     									 */
/* The project is based on AN2865 (MPC5500 & MPC5600 Simple Cookbook),		 */
/* example 15 eSCI: LIN Transmit.											 */
/* Example demonstrates the use of the eSCI module in LIN mode. The string	 */
/* 'Hello' will be transmitted via LIN. The communication can be observed by */
/* connecting a scope to the transmit pin.					    			 */
/*									   									     */
/*****************************************************************************/

/****************************** Includes *************************************/
#include "mpc5668.h"
/******************** Global variables and constants *************************/
const uint8_t FrameSpecAndData[] = {0x35,0x08,0xD0,'H','e','l','l','o',' ',' ',' '};

void initSysclk(void) {             /* Initialize PLL and sysclk to 64 MHz (set EMFD to 112 for 128MHz)*/

	int ERFD = 3;
	int EPREDIV = 9;
	int EMFD = 48;

	/* Select IRC as CLK Source */
	SIU.SYSCLK.B.SYSCLKSEL = 0x0;

	/* Configure PLL CTRL Regs */
	FMPLL.ESYNCR1.B.CLKCFG = 0x7; 
	FMPLL.ESYNCR2.B.ERFD = ERFD+2;
	FMPLL.ESYNCR1.B.EPREDIV = EPREDIV;
	FMPLL.ESYNCR1.B.EMFD = EMFD;

	/* Wait for PLL to lock */ 
	while(FMPLL.SYNSR.B.LOCK != 1);

	/* Change pll up to final freq */
	FMPLL.ESYNCR2.B.ERFD = ERFD;

	/* Switch from IRC to PLL */
	SIU.SYSCLK.B.SYSCLKSEL = 0x2;
	
	SIU.PCR[153].R = 0x060C; 	/* clkout - K9 */
	SIU.ECCR.B.ECDF = 0x1;     	/* CLKOUT = sys freq / 2. Set to 0 for sys freq.*/
	SIU.ECCR.B.ECEN = 1; 		/* enable CLKOUT */
}

void initESCI_A (void) {
	ESCI_A.CR2.R = 0x6240;		/* Module is enabled, 13 bit break, stop on errors */
	ESCI_A.CR1.R = 0x000C;  	/* Tx and Rx enabled */
	ESCI_A.BRR.R = 0x0180;		/* 10417 baud, 8 bits, no parity */
	ESCI_A.LCR1.R = 0x0100;  	/* eSCI put in LIN mode */
	SIU.PCR[60].R = 0x0400;     /* Configure pad for primary func: TxDA PD12*/
	SIU.PCR[61].R = 0x0400;   	/* Configure pad for primary func: RxDA PD13*/
}

void TransmitData (void) {
	uint8_t	j;                                        /* Dummy variable */
	for (j=0; j< sizeof (FrameSpecAndData); j++) {    /* Loop for character string */
		while (ESCI_A.IFSR2.B.TXRDY == 0) {};         /* Wait for LIN transmit ready = 1 */
		ESCI_A.IFSR2.R = 0x00004000;                  /* Clear TXRDY flag */
		ESCI_A.LTR.R = FrameSpecAndData[j] << 8;      /* Write byte to LIN Trans Reg. */
	}
}

void main(void) {
	initSysclk();       /* Set sysclk = 64MHz running from PLL */
	initESCI_A();       /* Enable Tx for 10417 baud, 8 bits, no parity */
	TransmitData();     /* Transmit string of characters on eSCI A */
	while (1) {}        /* Wait forever */
}
